class Respawnables_Pickup_Tornado extends Respawnables_Pickup;

auto state Pickup
{	
	function Touch( actor Other )
	{
		if ( ValidTouch(Other) && Other == Fragger ) 
			{
			if ( Pawn(Other).GroundSpeed == Pawn(Other).Default.GroundSpeed )
				{
				if ( Other.IsA('PlayerPawn') )
					{
					Respawnables_PRI(Pawn(Other).PlayerReplicationInfo).bHasTornado = True;
					Respawnables_PRI(Pawn(Other).PlayerReplicationInfo).NumItems += 1;
					}
				Pawn(Other).AirControl = 0.65;
				Pawn(Other).JumpZ *= 1.1;
				Pawn(Other).GroundSpeed *= 1.8;
				Pawn(Other).WaterSpeed *= 1.8;
				Pawn(Other).AirSpeed *= 1.8;
				Pawn(Other).Acceleration *= 2;
				PlayPickupMessage(Pawn(Other));
				PlaySound(PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
				}
			else
				{
				SetRespawn();
				}
			}
	}
}


defaultproperties
{
LifeTime=60
DrawType=DT_Sprite
CollisionRadius=32.00000
CollisionHeight=32.00000
Texture=Texture'reTornado'
PickupMessage="x2 Speed!"
ItemName="Tornado"
RespawnTime=0.000000
PickupSound=Sound'UnrealShare.Pickups.PSbelta2'
ScaleGlow=2.000000
bCollideWhenPlacing=True
RespawnTime=0
DrawScale=0.25
}
